#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);
const int size = 30 * 1000;
const int inf = 1000 * 1000 * 1000;

struct edge {
	int tg, flow, cap, back;

	edge(int tg_ = 0, int flow_ = 0, int cap_ = 0, int back_ = 0) : tg(tg_), flow(flow_), cap(cap_), back(back_) {}
};

vector <edge> vertex[size];
int n, m, str, fin;
int dist[size];
int cur[size];

void addedge(int v, int u) {
	edge e1(u, 0, 1, vertex[u].size());
	edge e2(v, 0, 0, vertex[v].size());

	vertex[v].pb(e1);
	vertex[u].pb(e2);
}

bool bfs() {
	for (int i = 0; i < n; i++)
		dist[i] = inf;
	dist[str] = 0;
	queue <int> q;
	q.push(str);

	while (!q.empty() && dist[fin] == inf) {
		int v = q.front();
		q.pop();
		for (int i = 0; i < (int) vertex[v].size(); i++)
			if (vertex[v][i].cap > vertex[v][i].flow && dist[vertex[v][i].tg] == inf) {
				dist[vertex[v][i].tg] = dist[v] + 1;
				q.push(vertex[v][i].tg);
			}
	}

	return dist[fin] < inf;
}

bool dfs(int v) {
	if (v == fin)
		return true;
	while (cur[v] < (int) vertex[v].size()) {
		if (dist[vertex[v][cur[v]].tg] != dist[v] + 1 || vertex[v][cur[v]].flow == vertex[v][cur[v]].cap) {
			cur[v]++;
			continue;
		}
		if (!dfs(vertex[v][cur[v]].tg))
			cur[v]++;
		else {
			vertex[v][cur[v]].flow++;
			vertex[vertex[v][cur[v]].tg][vertex[v][cur[v]].back].flow--;

			return true;
		}
	}

	return false;
}

int dinic() {
	int ans = 0;
	while (bfs()) {
		for (int i = 0; i < n; i++)
			cur[i] = 0;
		while (dfs(str))
			ans++;
	}

	return ans;
}

bool isleft[size];
bool isright[size];

void dfsdir(int v) {
	isleft[v] = true;
	for (int i = 0; i < (int) vertex[v].size(); i++)
		if (vertex[v][i].flow < vertex[v][i].cap && !isleft[vertex[v][i].tg])
			dfsdir(vertex[v][i].tg);
}

void dfsback(int v) {
	isright[v] = true;
	for (int i = 0; i < (int) vertex[v].size(); i++)
		if (vertex[v][i].flow == vertex[v][i].cap && !isright[vertex[v][i].tg])
			dfsback(vertex[v][i].tg);
}

int main() {
	assert(freopen("input.txt", "r", stdin));
	assert(freopen("output.txt", "w", stdout));

	while (true) {
		scanf("%d%d%d%d", &n, &m, &str, &fin);
		if (n == 0 && m == 0 && str == 0 && fin == 0)
			break;
		str--, fin--;

		for (int i = 0; i < m; i++) {
			int v, u;
			scanf("%d%d", &v, &u);
			v--, u--;

			addedge(v, u);
		}

		int ans = dinic();

		dfsdir(str);
		dfsback(fin);

		int psb = 0;
		for (int i = 0; i < n; i++)
			for (int j = 0; j < (int) vertex[i].size(); j++)
				if (vertex[i][j].cap == 1 && vertex[i][j].flow == 0 && isleft[vertex[i][j].tg] && isright[i])
					psb++;

		if (psb) {
			printf("%d %d\n", ans + 1, psb);
		} else {
			printf("%d %d\n", ans, psb);
		}

		for (int i = 0; i < n; i++) {
			vertex[i].clear();
			isleft[i] = false;
			isright[i] = false;
		}
	}

	return 0;
}